## Delete trailing spaces after \ to break line (or use quotes for literal space).

### Problematic code:

```sh
# There are spaces after the backslash:
echo hello \  
     world
```

### Correct code:

```sh
# No spaces after the backslash:
echo hello \
     world
```
### Rationale:

To break a line you can use `\` before the line break. However, if there are spaces after the backslash, the escape will apply to them instead of the line break, and the command will not continue on the next line.

Delete the trailing spaces to make the line break work correctly.

### Exceptions:

If you do want a literal escaped space at the end of a line you can ignore this error, but please reconsider and use quotes instead. Trailing whitespace is invisible and frequently stripped on purpose (by editor settings / precommits) or accident (copy-paste), and so should not be relied upon for correctness.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1101)

