## Add ;/& terminators (and other syntax) on the line with the <<, not here.

### Problematic code:

```sh
sudo bash -s << "END"
  cmd1
  cmd2
END &

```

### Correct code:

```sh
sudo bash -s << "END" &
  cmd1
  cmd2
END
```
### Rationale:

You are using `&`, `;`, `&>` or similar after a here document. This is not allowed.

This should instead be part of the line that initiated the here document, i.e. the one with the `<<`. 

If it helps, look at `<< "END"` as if it was `< file`, and make sure the resulting command is valid. This is what the shell does. You can then append here document data after the command.

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1121)

