# Expressions don't expand in single quotes, use double quotes for that.

### Problematic code:

```sh
name=World
echo 'Hello $name'
```

### Correct code:

```sh
name=World
echo "Hello $name"
```

### Rationale:

Single quotes prevent expansion of everything, including variables and command substitution.

If you want to use the values of variables and such, use double quotes instead.

Note that if you have other items that needs single quoting, you can use both in a single word:

```sh
echo '$1 USD is '"$rate GBP"
```

### Exceptions

If you want `$stuff` to be a literal dollar sign followed by the characters "stuff", you can [[ignore]] this message.

ShellCheck tries to be smart about it, and won't warn when this is used with awk, perl and similar, but there are some inherent ambiguities like `'I have $1 in my wallet'`, which could be "one dollar" or "whatever's in the first parameter".

In the particular case of `sed`, ShellCheck uses additional heuristics to try to separate cases like `'s/$foo/bar/'` (failing to replace the variable `$foo`) with from the false positives like `'$d'` (delete last line). If you're still triggering these, consider being more generous with your spaces: use `$ { s/foo/bar; }` instead of `${s/foo/bar/;}`


[Source](https://github.com/koalaman/shellcheck/wiki/SC2016)

