# Shell functions can't be passed to external commands.

### Problematic code:

```sh
foo() { bar --baz "$@"; frob --baz "$@"; };
find . -exec foo {} +
```

### Correct code:

```sh
find . -exec sh -c 'bar --baz "$@"; frob --baz "$@";' -- {} +
```

### Rationale:

Shell functions are only known to the shell. External commands like `find`, `xargs`, `su` and `sudo` do not recognize shell functions.

Instead, the function contents can be executed in a shell, either through `sh -c` or by creating a separate shell script as an executable file.

### Exceptions

If you're intentionally passing a word that happens to have the same name as a declared function, you can quote it to make shellcheck ignore it, e.g.

```sh
nobody() {
  sudo -u "nobody" "$@"
}

```

[Source](https://github.com/koalaman/shellcheck/wiki/SC2033)

