## This loop will only ever run once for a constant value. Did you perhaps mean to loop over dir/*, $var or $(cmd)?"

### Problematic code:

```sh
for var in value
do
  echo "$var"
done
```

### Correct code:

Correct code depends on what you want to do.

To iterate over files in a directory, instead of `for var in /my/dir` use:

```sh
for var in /my/dir/* ; do echo "$var"; done
```

To iterate over lines in a file or command output, use a while read loop instead:

```sh
mycommand | while IFS= read -r line; do echo "$line"; done
```

To iterate over *words* written to a command or function's stdout, instead of `for var in myfunction`, use

```sh
for var in $(myfunction); do echo "$var"; done
```

To iterate over *words* in a variable, instead of  `for var in myvariable`, use

```sh
for var in $myvariable; do echo "$var"; done
```



### Rationale:

ShellCheck has detected that your for loop iterates over a single, constant value. This is most likely a bug in your code, caused by you not expanding the value in the way you want.

You should make sure that whatever you loop over will expand into multiple words.

### Exceptions

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2043)

