## `break` is only valid in loops

### Problematic code:

```sh
case "$1" in
    -v)
       verbose=1
       break
       ;;
    -d)
       debug=1
esac
```

### Correct code:

```sh
case "$1" in
    -v)
       verbose=1
       ;;
    -d)
       debug=1
esac
```
### Rationale:

`break` or `continue` was found outside a loop. These statements are only valid in loops. In particular, `break` is not required in `case` statements as there is no implicit fall-through.

To return from a function or sourced script, use `return`. To exit a script, use `exit`.

### Exceptions:

It's possible to `break`/`continue` in a function without a loop. The call will then affect the loop -- if any -- that the function is invoked from. This is obviously not good coding practice.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2105)

