## Instead of [ a && b ], use [ a ] && [ b ].

### Problematic code:

```sh
[ "$1" = "-v" && -z "$2" ]
```

### Correct code:

```sh
[ "$1" = "-v" ] && [ -z "$2" ]
```

### Rationale:

`&&` can not be used in a `[ .. ]` test expression. Instead, make two `[ .. ]` expressions and put the `&&` between them.

### Exceptions:

None.

### Related resources:

* [Bash Pitfalls: [ "$foo" = bar && "$bar" = foo ]](https://mywiki.wooledge.org/BashPitfalls#pf6)
* [StackOverflow: using and (&&) operator in if statement bash script
](https://stackoverflow.com/questions/16396146/using-and-operator-in-if-statement-bash-script/16396181)
[Source](https://github.com/koalaman/shellcheck/wiki/SC2107)

