## This does not export 'FOO'. Remove $/${} for that, or use ${var?} to quiet.

### Problematic code:

```sh
MYVAR=foo
export $MYVAR
```

### Correct code:

```sh
MYVAR=foo
export MYVAR
```

### Rationale:

`export` takes a variable name, but shellcheck has noticed that you give it an expanded variable instead. The problematic code does not export `MYVAR` but a variable called `foo` if any.

### Exceptions:

If this is intentional and you do want to export `foo` instead of `MYVAR`, you can either use a directive:

```sh
# shellcheck disable=SC2163
export "$MYVAR"
```

Or after (but not including) version 0.4.7, take advantage of the fact that ShellCheck only warns when no parameter expansion modifiers are applied:

```sh
export "${MYVAR}"    # ShellCheck warns
export "${MYVAR?}"   # No warning
```

`${MYVAR?}` fails when `MYVAR` is unset, which is fine since `export` would have failed too. The main side effect is an improved runtime error message in that case.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2163)

