## Numerical -eq does not dereference in [..]. Expand or use string operator.

### Problematic code:

```sh
read -r n
if [ n -lt 0 ]
then
   echo "bad input"
fi
```

### Correct code:

```sh
read -r n
if [ "$n" -lt 0 ]
then
   echo "bad input"
fi
```
### Rationale:

You are comparing a string value with a numerical operator, such as `-eq`, `-ne`, `-lt` or `-gt`.

In `[[ .. ]]`, this would automatically dereference the string, looking to see if there are variables by that name.

In `[ .. ]`, which you are using, the string is just treated as an invalid number.

If you want to compare numbers, expand yourself (e.g. use `$var` instead of `var`). If you are trying to compare strings and not numbers, use `=`, `!=` `\<` or `\>` instead.

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2170)

