## Trapping signals by number is not well defined. Prefer signal names.

### Problematic code:

```sh
trap myfunc 28
```

### Correct code:

```sh
trap myfunc WINCH
```
### Rationale:

Signal numbers can vary between platforms. Prefer signal names, which are fixed.

Signal numbers 1, 2, 3, 6, 9, 14 and 15 are specified as parts of the optional POSIX XSI and ShellCheck will not warn about these. 

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2172)

