## This array element has no value. Remove spaces after = or use "" for empty string.
### Problematic code:

```sh
array=([1]=one [2]= two)
```

### Correct code:

```sh
array=([1]=one [2]=two)
```
### Rationale:

You have an array element on the form `[index]=`. The shell will interpret this as an independent element with index `index` and value `<empty string>`.

This may happen as part of the expression `[index]= value`, where the space is not allowed and causes the shell to interpret it as `[index]="" [index+1]=value`.

If you wanted the element to have a value, remove the spaces after `=`, e.g. `[index]=value`.

If you wanted to assign an empty string, explicitly use emtpy quotes: `[index]=""`. This makes no difference to the shell, but will make your intention clear to shellcheck and other humans. 

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2192)

