## (..) is a subshell. Did you mean [ .. ], a test expression?

### Problematic code:

```sh
if ( -d mydir )
then
  echo "It's a directory"
fi
```

### Correct code:

```sh
if [ -d mydir ]
then
  echo "It's a directory"
fi
```
### Rationale:

Tests like `-d` to see if something is a directory or `-z` to see if it's non-empty are actually flags to the `test` command, and only work as tests in that context. `[` is an alias for `test`, so you'll frequently see them written as `[ -d mydir ]`.

`( .. )` is completely unrelated, and is a subshell mostly used to scope shell modifications. They should not be used in `if` or `while` statements in shell scripts.

If you wanted to test a condition, rewrite the `( .. )` to `[ .. ]`. 

### Exceptions:

None. 

This error is triggered by having a unary test operator as the first command name in a subshell, which won't normally happen. Note that there's a similar warning [[SC2205]] with a higher false positive rate.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2204)

