## Instead of `let expr`, prefer `(( expr ))` .

### Problematic code:

```sh
let a++
```

### Correct code:

```sh
(( a++ ))
```
### Rationale:

The `(( .. ))` arithmetic compound command evaluates expressions in the same way as `let`, except it's not subject to glob expansion and therefore requires no additional quoting or escaping. 

This warning only triggers in Bash/Ksh scripts. In Sh/Dash, neither `let` nor `(( .. ))` are defined, but can be simulated with `[ $(( expr )) -ne 0 ]` to retain exit code, or `: $(( expr ))` to ignore it.

### Exceptions:

None.

### More information

* Bash Hacker's Wiki: [The let builtin command](http://wiki.bash-hackers.org/commands/builtin/let)
[Source](https://github.com/koalaman/shellcheck/wiki/SC2219)

