
There's no point in having a test class without any test methods.This could lead a maintainer to assume a class is covered by tests even though it<br>is not.

Supported test frameworks are `NUnit` and `MSTest` (not applicable to `xUnit`).

This rule will raise an issue when any of these conditions are met:

- For **NUnit**, a class is marked with `TestFixture` but does not contain any method marked with `Test`,<br>  `TestCase`, `TestCaseSource` or `Theory`.
- For **MSTest**, a class is marked with `TestClass` but does not contain any method marked with `TestMethod`<br>  or `DataTestMethod`.


## Noncompliant Code Example


    [TestFixture]
    public class SomeClassTest { } // Noncompliant - no test
    
    [TestClass]
    public class SomeOtherClassTest { } // Noncompliant - no test


## Compliant Solution


    [TestFixture]
    public class SomeClassTest
    {
        [Test]
        public void SomeMethodShouldReturnTrue() { }
    }
    
    [TestClass]
    public class SomeOtherClassTest
    {
        [TestMethod]
        public void SomeMethodShouldReturnTrue() { }
    }


## Exceptions

- abstract classes
- derived classes that inherit from a base class that does have test methods
- in **MSTest**, classes that contain methods marked with either `AssemblyInitialize` or `AssemblyCleanup`.<br>

