
Debug statements are always useful during development. But include them in production code - particularly in code that runs client-side - and you<br>run the risk of inadvertently exposing sensitive information.

## Noncompliant Code Example


    private void DoSomething()
    {
        // ...
        Console.WriteLine("so far, so good..."); // Noncompliant
        // ...
    }


## Exceptions

The following are ignored by this rule:

- Console Applications
- Calls in methods decorated with `[Conditional ("DEBUG")]`
- Calls included in DEBUG preprocessor branches (`#if DEBUG`)


## See

- [OWASP Top 10 2017 Category A3](https://www.owasp.org/index.php/Top_10-2017_A3-Sensitive_Data_Exposure) - Sensitive Data Exposure<br>

