
An assertion is a piece of code that's used during development when the compilation debug mode is activated. It allows a program to check itself as<br>it runs. When an assertion is true, that means everything is operating as expected.

In non-debug mode, all `Debug.Assert` are automatically left out. So, by contract, the boolean expressions that are evaluated by those<br>assertions must absolutely not contain any side effects. Otherwise, when leaving the Debug mode, the functional behavior of the application is not the<br>same anymore.

The rule will raise if the method name starts with any of the following `remove`, `delete`, `add`,<br>`pop`, `update`, `retain`, `insert`, `push`, `append`, `clear`,<br>`dequeue`, `enqueue`, `dispose`, `put`, or `set`, although `SetEquals` will be<br>ignored.

## Noncompliant Code Example


    Debug.Assert(list.Remove("dog"));


## Compliant Solution


    bool result = list.Remove("dog");
    Debug.Assert(result);


## See

- [CERT, EXP06-J.](https://www.securecoding.cert.org/confluence/x/vwG7AQ) - Expressions used in assertions must not produce side<br>  effects

