
Just because you *can* do something, doesn't mean you should, and that's the case with nested ternary operations. Nesting ternary operators<br>results in the kind of code that may seem clear as day when you write it, but six months later will leave maintainers (or worse - future you)<br>scratching their heads and cursing.

Instead, err on the side of clarity, and use another line to express the nested operation as a separate statement.

## Noncompliant Code Example


    public string GetTitle(Person p)
    {
      return p.Gender == Gender.MALE ? "Mr. " : p.IsMarried ? "Mrs. " : "Miss ";  // Noncompliant
    }


## Compliant Solution


    public string GetTitle(Person p)
    {
      if (p.Gender == Gender.MALE)
      {
        return "Mr. ";
      }
      return p.IsMarried ? "Mrs. " : "Miss ";
    }

