
Many string operations, the `Compare` and `Equals` methods in particular, provide an overload that accepts a<br>`StringComparison` enumeration value as a parameter. Calling these overloads and explicitly providing this parameter makes your code<br>clearer and easier to maintain.

This rule raises an issue when a string comparison operation doesn't use the overload that takes a `StringComparison` parameter.

## Noncompliant Code Example


    using System;
    
    namespace MyLibrary
    {
      public class Foo
      {
        public bool HaveSameNames(string name1, string name2)
        {
          return string.Compare(name1, name2) == 0; // Noncompliant
        }
      }
    }


## Compliant Solution


    using System;
    
    namespace MyLibrary
    {
      public class Foo
      {
        public bool HaveSameNames(string name1, string name2)
        {
          return string.Compare(name1, name2, StringComparison.OrdinalIgnoreCase) == 0;
        }
      }
    }

