B103: Test for setting permissive file permissions
--------------------------------------------------

POSIX based operating systems utilize a permissions model to protect
access to parts of the file system. This model supports three roles
"owner", "group" and "world" each role may have a combination of "read",
"write" or "execute" flags sets. Python provides `chmod`{.docutils
.literal .notranslate} to manipulate POSIX style permissions.

This plugin test looks for the use of `chmod`{.docutils .literal
.notranslate} and will alert when it is used to set particularly
permissive control flags. A MEDIUM warning is generated if a file is set
to group executable and a HIGH warning is reported if a file is set
world writable. Warnings are given with HIGH confidence.
