**B105: Test for use of hard-coded password strings**

The use of hard-coded passwords increases the possibility of password
guessing tremendously. This plugin test looks for all string literals
and checks the following conditions:

-   assigned to a variable that looks like a password

-   assigned to a dict key that looks like a password

-   used in a comparison with a variable that looks like a password

Variables are considered to look like a password if they have match any
one of:

-   "password"

-   "pass"

-   "passwd"

-   "pwd"

-   "secret"

-   "token"

-   "secrete"

Note: this can be noisy and may generate false positives.

**Config Options:**

None

Example

:   

<!-- -->

    >> Issue: Possible hardcoded password '(root)'
       Severity: Low   Confidence: Low
       Location: ./examples/hardcoded-passwords.py:5
    4 def someFunction2(password):
    5     if password == "root":
    6         print("OK, logged in")

See also

-   <https://www.owasp.org/index.php/Use_of_hard-coded_password>

New in version 0.9.0.
