## Use absolute WORKDIR.

### Problematic code:

```dockerfile
FROM busybox
WORKDIR usr/src/app
```

### Correct code:

```dockerfile
FROM busybox
WORKDIR /usr/src/app
```
### Rationale:

By using absolute paths you will not run into problems when a previous `WORKDIR` instruction
changes. You also often times don't know the `WORKDIR` context of your base container.

### Exceptions:

When using environment replacements.

```dockerfile
FROM busybox
ENV foo /bar
WORKDIR ${foo}   # WORKDIR /bar
```