## Pin versions in `apk add`

### Problematic code:

```dockerfile
FROM alpine:3.7
RUN apk --no-cache add foo
```

### Correct code (Partial pin glob):

```dockerfile
FROM alpine:3.7
RUN apk --no-cache add foo=~1.23
```

### Correct code (Exact pin):

```dockerfile
FROM alpine:3.7
RUN apk --no-cache add foo=1.2.3
```

**Note:** Pinning exact versions can cause future builds to suddenly fail if that version is no longer available. Use with caution. 

### Rationale:

Version pinning forces the build to retrieve a limited range of versions, or an exact particular version, regardless of what’s in the cache. This technique can also reduce failures due to unanticipated changes in required packages.

> https://docs.docker.com/engine/articles/dockerfile_best-practices/