## Use arguments JSON notation for CMD and ENTRYPOINT arguments

### Problematic code:

```dockerfile
FROM busybox
ENTRYPOINT s3cmd
```

```dockerfile
FROM busybox
CMD my-service server
```

### Correct code:

```dockerfile
FROM busybox
ENTRYPOINT ["s3cmd"]
```

```dockerfile
FROM busybox
CMD ["my-service", "server"]
```

**Warning**: Docker `CMD` does not process `$ENVIRONMENT_VARIABLE`s, that’s a side-effect of using `sh -c` as the default entry-point. Using the JSON notation means that you have to figure out how to handle environment variables yourself.

**Warning**: The CMD exec form is parsed as a JSON array, so you **MUST** use double quotes (`"`) instead of single quote (`'`). See https://docs.docker.com/v17.09/engine/reference/builder/#cmd for more info.

### Rationale:

When using the plain text version of passing arguments, signals from the OS are not correctly passed to the executables, which is in the majority of the cases what you would expect.

https://docs.docker.com/engine/articles/dockerfile_best-practices/

> `CMD` should almost always be used in the form of `CMD [“executable”, “param1”, “param2”…]`

> The shell form prevents any CMD or run command line arguments from being used, but has the disadvantage that your ENTRYPOINT will be started as a subcommand of /bin/sh -c, which does not pass signals. This means that the executable will not be the container’s PID 1 - and will not receive Unix signals - so your executable will not receive a SIGTERM from docker stop <container>.