# For command expansion, the tick should slant left (` vs ´).


### Problematic code:

```sh
echo "Your username is ´whoami´"
```

### Correct code:

```sh
echo "Your username is $(whoami)" # Preferred
echo "Your username is `whoami`"  # Deprecated, will give [SC2006]
```

### Rationale:

In some fonts it's hard to tell ticks apart, but Bash strongly distinguishes between backticks (grave accent `` ` ``), forward ticks (acute accent `´`) and regular ticks (apostrophe `'`).

Backticks start command expansions, while forward ticks are literal. To help spot bugs, ShellCheck parses backticks and forward ticks interchangeably.

### Exceptions

If you want to write out literal forward ticks, such as fancyful ascii quotation marks:

```sh
echo "``Proprietary software is an injustice.´´  - Richard Stallman"
```

use single quotes instead:

```sh
echo '``Proprietary software is an injustice.´´  - Richard Stallman'
```

To nest forward ticks in command expansion, use `$(..)` instead of `` `..` ``.
