## Want to escape a single quote? echo 'This is how it'\\''s done'.

(Note: in v0.4.6, the error message was accidentally missing the backslash)

### Problematic code:

```sh
echo 'This is not how it\'s done'.
```

### Correct code:

```sh
echo 'This is how it'\''s done'.
```


### Rationale

In POSIX shell, the shell cares about nothing but another single quote to terminate the quoted segment. Not even backslashes are interpreted.

[POSIX.1 Shell Command Language § 2.2.2 Single Quotes](http://pubs.opengroup.org/onlinepubs/9699919799/utilities/V3_chap02.html#tag_18_02_02):

> Enclosing characters in single-quotes ( `''` ) shall preserve the literal value of each character within the single-quotes. A single-quote cannot occur within single-quotes.

### Exceptions
If you want your single quoted string to end in a backslash, you can rewrite as `'string'\\` or [[ignore]] this warning.

[Source](https://github.com/koalaman/shellcheck/wiki/SC1003)

