## This is a unicode double quote. Delete and retype it.

### Problematic code:

```sh
echo “hello world”
```

### Correct code:

```sh
echo "hello world"
```

### Rationale:

Blog software and word processors frequently replaces ASCII quotes `""` with fancy Unicode quotes, `“”`. To bash, Unicode quotes are considered regular literals and not quotes at all.

Simply delete them and retype them in your editor.

### Status:

This error was retired after 0.4.5. In this version and earlier, ShellCheck parsed slanted quotes as a valid double quote. This meant that the warning could not simply be ignored. It has since been replaced by [[SC1110]] (outside quotes) and [[SC1111]] (inside double quotes).

### Exceptions

If you really want literal Unicode double quotes, you can put them in single quotes (or Unicode single quotes in double quotes) to make shellcheck ignore them, e.g.,

```sh
printf 'Warning: “wakeonlan” is not installed.\n'
```
[Source](https://github.com/koalaman/shellcheck/wiki/SC1015)

