## Did you forget the 'then' for this 'if'?

### Problematic code:

```sh
if true
  echo "foo"
elif true
  echo "bar"
fi
```

### Correct code:

```sh
if true
then
  echo "foo"
elif true
then
  echo "bar"
fi
```

### Rationale:

ShellCheck found a parsing error in the script, and determined that it's most likely due to a missing `then` keyword for the `if` or `elif` indicated.

Make sure the `then` is there. 

Note that the `then` needs a `;` or linefeed before it. `if true then` is invalid, while `if true; then` is correct.

### Exceptions:

None
[Source](https://github.com/koalaman/shellcheck/wiki/SC1049)

