## ShellCheck only supports sh/bash/dash/ksh scripts. Sorry!

### Problematic code:

```sh
#!/usr/bin/python
print "Hello"
```

### Rationale:

You have specified the shebang of an unsupported language or shell dialect.

ShellCheck only supports a limited number of Bourne-based Unix shells: bash, ksh, dash and POSIX sh.

It does not support scripts written for other shells like Zsh, Csh, Tcsh or PowerShell, and it does not support other scripting languages like PHP, Python, JavaScript or SQL.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1071)

