## This `{`/`}` is literal. Check expression (missing `;/\n?`) or quote it.

### Problematic code:

```sh
rmf() { rm -f "$@" }
```

or

```sh
eval echo \${foo}
```

### Correct code:

```sh
rmf() { rm -f "$@"; }
```

and

```sh
eval "echo \${foo}"
```

### Rationale:

Curly brackets are normally used as syntax in parameter expansion, command grouping and brace expansion.

However, if they don't appear alone at the start of an expression or as part of a parameter or brace expansion, the shell silently treats them as literals. This frequently indicates a bug, so ShellCheck warns about it.

In the example function, the `}` is literal because it's not at the start of an expression. We fix it by adding a `;` before it.

In the example eval, the code works fine. However, we can quiet the warning and follow good practice by adding quotes around the literal data.

ShellCheck does not warn about `{}`, since this is frequently used with `find` and rarely indicates a bug.

### Exceptions

This error is harmless when the curly brackets are supposed to be literal, in e.g. `awk {'print $1'}`. However, it's cleaner and less error prone to simply include them inside the quotes: `awk '{print $1}'`.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1083)

