## Parsing stopped here. Invalid use of parentheses?

### Problematic code:

```sh
grep ^(.*)\1$ file
```

or

```sh
var = myfunction(value)
```

### Correct code:

```sh
grep '^(.*)\1$' file
```

or

```sh
var=$(myfunction value)
```

### Rationale:

Parentheses are shell syntax and must be used correctly.

For commands that expect literal parentheses, such as `grep` or `find`, the parentheses need to be quoted or escaped so the shell does not interpret them, but instead passes them to the command.

For shell syntax, the shell does not use them the way most other languages do, so avoid guessing at syntax based on previous experience. In particular:

- Parentheses are NOT used to call functions.
- Parentheses are NOT used to group expressions, except in arithmetic contexts.
- Parentheses are NOT used in conditional statements or loops.
- Parentheses are used differently in different contexts. `( .. )`, `$( .. )`, `$(( .. ))` and `var=(..)` are completely separate and independent structures with different meanings, and can not be broken down into operations on expressions in parentheses.

  In C-like languages, `++` can't be broken down into two `+` operations, so you can't e.g. use `+ +` or `+(+)`. In the same way, all of the above are completely unrelated so that you can't do `$(1+1)` or `$( (1+1) )` in place of `$(( 1+1 ))`.

If you are trying to use parentheses for shell syntax, look up the actual syntax of the statement you are trying to use.

### Exceptions:

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC1088)

