## This is a unicode quote. Delete and retype it (or quote to make literal).

### Problematic code:

```sh
echo ‘hello world’
```

### Correct code:

```sh
echo 'hello world'
```

### Rationale:

Some software, like OS X, Word and WordPress, may automatically replace your regular quotes with slanted Unicode quotes. Try deleting and retyping them, and/or disable “smart quotes” in your editor or OS.

### Exceptions

If you want to use typographic single quotes, you can put them in double quotes (or typographic double quotes in single quotes) to make shellcheck ignore them, e.g.,

```sh
printf "Warning: ‘wakeonlan’ is not installed.\n"
```
[Source](https://github.com/koalaman/shellcheck/wiki/SC1110)

