## Prefer escape over ending quote to make `$` literal. Instead of `"It costs $"5`, use `"It costs \$5"`

### Problematic code:

```sh
echo "The apples are $""1 each"
eval "var=$"name
```

### Correct code:

```sh
echo "The apples are \$1 each"
eval "var=\$name"
# or better yet: var="${!name}"
```

### Rationale:

The script appears to be closing a double quoted string for the sole purpose of making a dollar sign `$` literal.

While this happens to work, the better solution is instead to escape it with a backslash. This allows the double quoted string to continue uninterrupted, thereby reducing the visual noise of stopping and starting quotes in the middle of a shell word.

### Exceptions:

None

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC1135)

