# expr is antiquated. Consider rewriting this using $((..)), ${} or \[\[ \]\].

### Problematic code:

```sh
i=$(expr 1 + 2)
l=$(expr length "$var")
```

### Correct code:

```sh
i=$((1+2))
l=${#var}
```

### Rationale:

[To quote POSIX:](http://pubs.opengroup.org/onlinepubs/009695399/utilities/expr.html)

> The expr utility has a rather difficult syntax [...] In many cases, the arithmetic and string features provided as part of the shell command language are easier to use than their equivalents in expr. Newly written scripts should avoid expr in favor of the new features within the shell.

### Exceptions

`sh` doesn't have a great replacement for the `:` operator (regex match). ShellCheck tries not to warn when using expr with `:`, but e.g. `op=:; expr string "$op" regex` will still trigger it.

Other than that, all uses of `expr` can be rewritten to use modern shell features instead.

Bash has `[[ string =~ regex ]]`, so not even `expr .. : ..` is necessary.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2003)

