## Consider using { cmd1; cmd2; } >> file instead of individual redirects.

### Problematic code:

```sh
echo foo >> file
date >> file
cat stuff  >> file

```

### Correct code:

```sh
{
  echo foo
  date
  cat stuff
} >> file
```

### Rationale:

Rather than adding `>> something` after every single line, you can simply group the relevant commands and redirect the group. So the file has to be opened and closed only once and it means a performance gain.

### Exceptions:

This is mainly a stylistic issue, and can freely be ignored.

### Related resources:

* [BashFaq: How can I redirect the output of multiple commands at once?](https://mywiki.wooledge.org/BashFAQ/014)
[Source](https://github.com/koalaman/shellcheck/wiki/SC2129)

