## The arguments to this comparison can never be equal. Make sure your syntax is correct.

### Problematic code:

```sh
[ $var+1 == 5 ]              # Unevaluated math
[ "{$var}" == "value" ]      # Swapped around $ and {
[ "$(cmd1) | cmd2" == "42" ] # Ended with ) too soon
[[ "$var " == *.png ]]       # Trailing space
```

### Correct code:

```sh
[ $((var+1)) == 5 ]          # Evaluated math
[ "${var}" == "value" ]      # Correct variable expansion
[ "$(cmd1 | cmd2)" == "42" ] # Correct command substitution
[[ "$var" == *.png ]]        # No trailing space
```
### Rationale:

ShellCheck has determined that the two values you're comparing can never be equal. 

Most of the time, this happens because of a syntax issue that introduced unintended literal characters into one of the arguments.

The left-hand side in the problematic examples will always contain (respectively) curly braces, pipe and trailing space. The right-hand sides are literal values and a pattern without trailing spaces, so they will never be equal. The statement is therefore useless, strongly indicating a bug. 

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2193)

