## getopts specified -n, but it's not handled by this 'case'.

### Problematic code:

```sh
while getopts "vrn" n
do
  case "$n" in
    v) echo "Verbose" ;;
    r) echo "Recursive" ;;
    \?) usage;;
  esac
done
```

### Correct code:

```sh
while getopts "vrn" n
do
  case "$n" in
    v) echo "Verbose" ;;
    r) echo "Recursive" ;;
    n) echo "Dry-run" ;;    # -n handled here
    \?) usage;;
  esac
done
```
### Rationale:

You have a `while getopts` loop where the corresponding `case` statement fails to handle one of the flags.

Either add a case to handle the flag, or remove it from the `getopts` option string.

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2213)

