## Use `[ -n .. ]` instead of `! [ -z .. ]`.

(or "Use `[ -z .. ]` instead of `! [ -n .. ]`.)

### Problematic code:

```sh
if ! [ -n "$JAVA_HOME" ]; then echo "JAVA_HOME not specified"; fi
if ! [ -z "$STY" ];       then echo "You are already running screen"; fi
```

### Correct code:

```sh
if [ -z "$JAVA_HOME" ]; then echo "JAVA_HOME not specified"; fi
if [ -n "$STY" ];       then echo "You are already running screen"; fi
```

### Rationale:

You have negated `test -z` or `test -n`, resulting in a needless double-negative. You can just use the other operator instead:

    # Identical tests to verify that a value is assigned
    ! [ -z foo ] # Not has no value
    [ -n foo ]   # Has value

    # Identical tests to verify that a value is empty
    ! [ -n foo ] # Not is non-empty
    [ -z foo ]   # Is empty

### Exceptions:

This is a stylistic issue that does not affect correctness. If you prefer the original expression, you can't not [[Ignore]] it with a directive or flag.

### Related resources:

* [Google Bash Style Guide][google-bash] on Testing Strings
* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!

[google-bash]: https://google.github.io/styleguide/shell.xml?showone=Testing_Strings#Testing_Strings
[Source](https://github.com/koalaman/shellcheck/wiki/SC2237)

