## Flip leading $ and " if this should be a quoted substitution.

### Problematic code:

```sh
var=$"(whoami)"
```

### Correct code:

```sh
var="$(whoami)"
```

### Rationale:

ShellCheck has found a `$"(` or `$"{` . This is most likely due to flipping the dollar-sign and double quote:

    echo $"(cmd)"  # Supposed to be "$(cmd)"
    echo $"{var}"  # Supposed to be "${var}"

Instead of quoted substitutions, these will be interpreted as localized string resources (`$".."`) containing literal parentheses or curly braces. If this was not intentional, you should flip the `"` and `$` like in the example.

### Exceptions:

If you intentionally wanted a localized string literal `$".."` that starts with `(` or `{`, either [[ignore]] this error or start it with a different character.

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC2247)

