
Default arguments are determined by the static type of the object. If a default argument is different for a parameter in an overriding method, the<br>value used in the call will be different when calls are made via the base or derived object, which may be contrary to developer expectations.

Default parameter values are useless in explicit interface implementations, because the static type of the object will always be the implemented<br>interface. Thus, specifying default values is useless and confusing.

## Noncompliant Code Example


    public class Base
    {
      public virtual void Write(int i = 42)
      {
        Console.WriteLine(i);
      }
    }
    
    public class Derived : Base
    {
      public override void Write(int i = 5) // Noncompliant
      {
        Console.WriteLine(i);
      }
    }
    
    public class Program
    {
      public static void Main()
      {
        var derived = new Derived();
        derived.Write(); // writes 5
        Print(derived);  // writes 42; was that expected?
      }
      private void Print(Base item)
      {
        item.Write();
      }
    }


## Compliant Solution


    public class Base
    {
      public virtual void Write(int i = 42)
      {
        Console.WriteLine(i);
      }
    }
    
    public class Derived : Base
    {
      public override void Write(int i = 42)
      {
        Console.WriteLine(i);
      }
    }
    
    public class Program
    {
      public static void Main()
      {
        var derived = new Derived();
        derived.Write(); // writes 42
        Print(derived);  // writes 42
      }
      private void Print(Base item)
      {
        item.Write();
      }
    }


## See

- MISRA C++ 2008, 8-3-1 - Parameters in a overriding virtual function shall either use the same default arguments as the function they override,<br>  or else shall not specify any default arguments.

