
According to the Single Responsibility Principle, introduced by Robert C. Martin in his book "Principles of Object Oriented Design", a class should<br>have only one responsibility:


> If a class has more than one responsibility, then the responsibilities become coupled.
> 
> Changes to one responsibility may impair or inhibit the class' ability to meet the others.
> 
> This kind of coupling leads to fragile designs that break in unexpected ways when changed.


Classes which rely on many other classes tend to aggregate too many responsibilities and should be split into several smaller ones.

Nested classes dependencies are not counted as dependencies of the outer class.

## Noncompliant Code Example

With a threshold of 5:


    public class Foo    // Noncompliant - Foo depends on too many classes: T1, T2, T3, T4, T5, T6 and T7
    {
      private T1 a1;    // Foo is coupled to T1
      private T2 a2;    // Foo is coupled to T2
      private T3 a3;    // Foo is coupled to T3
    
      public T4 Compute(T5 a, T6 b)    // Foo is coupled to T4, T5 and T6
      {
        T7 result = a.Process(b);    // Foo is coupled to T7
        return result;
      }
    
      public static class Bar    // Compliant - Bar depends on 2 classes: T8 and T9
      {
        public T8 a8;
        public T9 a9;
      }
    }

