
When `switch` statements have large sets of case clauses, it is usually an attempt to map two sets of data. A `Dictionary`<br>should be used instead to make the code more readable and maintainable.

## Noncompliant Code Example

With a "Maximum number of case" set to 4


    public class TooManyCase
    {
        public int switchCase(char ch)
        {
            switch(ch) {  // Noncompliant
                case 'a':
                    return 1;
                case 'b':
                case 'c':
                    return 2;
                case 'd':
                    return 3;
                case 'e':
                    return 4;
                case 'f':
                case 'g':
                case 'h':
                    return 5;
                default:
                    return 6;
            }
        }
    }


## Compliant Solution


    using System.Collections.Generic;
    
    public class TooManyCase
    {
        Dictionary&lt;char, int&gt; matching = new Dictionary&lt;char, int&gt;()
        {
            {'a', 1}, {'b', 2}, {'c', 2}, {'d', 3},
            {'e', 4}, {'f', 5}, {'g', 5}, {'h', 5}
        };
    
        public int withDictionary(char ch)
        {
            int value;
            if (this.matching.TryGetValue(ch, out value)) {
                return value;
            } else {
                return 6;
            }
        }
    }


## Exceptions

This rule ignores `switch`es over `Enum`s and empty, fall-through cases.
