
When a cookie is protected with the `secure` attribute set to *true* it will not be send by the browser over an unencrypted HTTP<br>request and thus cannot be observed by an unauthorized person during a man-in-the-middle attack. By default the `secure` flag is set to<br>*false* and so cookies can be stolen if a man-in-the-attack is performed.

## Ask Yourself Whether

- the cookie is for instance a *session-cookie* not designed to be sent over non-HTTPS communication.
- it's not sure that the website contains [mixed content](https://developer.mozilla.org/fr/docs/S%C3%A9curit%C3%A9/MixedContent) or<br>  not (ie HTTPS everywhere or not)


You are at risk if you answered yes to any of those questions.

## Recommended Secure Coding Practices

- It is recommended to use `HTTPs` everywhere so setting the `secure` flag to *true* should be the default behaviour<br>  when creating cookies.
- Set the `secure` flag to *true* for session-cookies.


## Sensitive Code Examples

In C# you can specify the secure flag with the HttpCookie.secure property:


    HttpCookie myCookie = new HttpCookie("Sensitive cookie");
    myCookie.Secure = false; //  Sensitive: a security-sensitive cookie is created with the secure flag set to false


The [default value](https://docs.microsoft.com/en-us/dotnet/api/system.web.httpcookie.secure?view=netframework-4.8) of<br>`secure` flag is false:


    HttpCookie myCookie = new HttpCookie("Sensitive cookie");
    //  Sensitive: a security-sensitive cookie is created with the secure flag not defined (by default set to false)


## Compliant Solution


    HttpCookie myCookie = new HttpCookie("Sensitive cookie");
    myCookie.Secure = true; // Compliant: the security-sensitive cookie will not be send during an unencrypted HTTP request thanks to the secure flag (Secure property) set to true


## See

- [OWASP Top 10 2017 Category A3](https://www.owasp.org/index.php/Top_10-2017_A3-Sensitive_Data_Exposure) - Sensitive Data Exposure<br>
- [MITRE, CWE-311](http://cwe.mitre.org/data/definitions/311) - Missing Encryption of Sensitive Data
- [MITRE, CWE-315](http://cwe.mitre.org/data/definitions/315) - Cleartext Storage of Sensitive Information in a Cookie
- [MITRE, CWE-614](http://cwe.mitre.org/data/definitions/614) - Sensitive Cookie in HTTPS Session Without 'Secure' Attribute
- [SANS Top 25](https://www.sans.org/top25-software-errors/#cat3) - Porous Defenses

