
When the names of parameters in a method call match the names of the method arguments, it contributes to clearer, more readable code. However, when<br>the names match, but are passed in a different order than the method arguments, it indicates a mistake in the parameter order which will likely lead<br>to unexpected results.

## Noncompliant Code Example


    public double Divide(int divisor, int dividend)
    {
        return divisor/dividend;
    }
    
    public void DoTheThing()
    {
        int divisor = 15;
        int dividend = 5;
    
        double result = Divide(dividend, divisor);  // Noncompliant; operation succeeds, but result is unexpected
        //...
    }


## Compliant Solution


    public double Divide(int divisor, int dividend)
    {
        return divisor/dividend;
    }
    
    public void DoTheThing()
    {
        int divisor = 15;
        int dividend = 5;
    
        double result = Divide(divisor, dividend);
        //...
    }

