
Methods and properties that don't access instance data can be `static` to prevent any misunderstanding about the contract of the method.

## Noncompliant Code Example


    public class Utilities
    {
        public int MagicNum // Noncompliant
        {
            get
            {
                return 42;
            }
        }
    
        private static string magicWord = "please";
        public string MagicWord  // Noncompliant
        {
            get
            {
                return magicWord;
            }
            set
            {
                magicWord = value;
            }
      }
    
        public int Sum(int a, int b)  // Noncompliant
        {
            return a + b;
        }
    }


## Compliant Solution


    public class Utilities
    {
        public static int MagicNum
        {
            get
            {
                return 42;
            }
        }
    
        private static string magicWord = "please";
        public static string MagicWord
        {
            get
            {
                return magicWord;
            }
            set
            {
                magicWord = value;
            }
        }
    
        public static int Sum(int a, int b)
        {
            return a + b;
        }
    }


## Exceptions

Methods with the following names are excluded because they can't be made `static`:

- Application\_AuthenticateRequest
- Application\_BeginRequest
- Application\_End
- Application\_EndRequest
- Application\_Error
- Application\_Init
- Application\_Start
- Session\_End
- Session\_Start

