
A `catch` clause that only rethrows the caught exception has the same effect as omitting the `catch` altogether and letting<br>it bubble up automatically, but with more code and the additional detriment of leaving maintainers scratching their heads.

Such clauses should either be eliminated or populated with the appropriate logic.

## Noncompliant Code Example


    string s = "";
    try
    {
      s = File.ReadAllText(fileName);
    }
    catch (Exception e)  // Noncompliant
    {
      throw;
    }


## Compliant Solution


    string s = "";
    try
    {
      s = File.ReadAllText(fileName);
    }
    catch (Exception e) // Compliant
    {
      logger.LogError(e);
      throw;
    }


or


    string s = File.ReadAllText(fileName);


## Exceptions

This rule will not generate issues for `catch` blocks with just `throw` inside if they are followed by a `catch`<br>block for a more general exception type that does more than just rethrowing the exception.


    var s = ""
    try
    {
        s = File.ReadAllText(fileName);
    }
    catch (IOException) // Compliant, if removed will change the logic
    {
        throw;
    }
    catch (Exception)  // Compliant, does more than just rethrow
    {
        logger.LogError(e);
        throw;
    }

