
When a cookie is configured with the `HttpOnly` attribute set to *true*, the browser guaranties that no client-side script will<br>be able to read it. In most cases, when a cookie is created, the default value of `HttpOnly` is *false* and it's up to the developer<br>to decide whether or not the content of the cookie can be read by the client-side script. As a majority of Cross-Site Scripting (XSS) attacks target<br>the theft of session-cookies, the `HttpOnly` attribute can help to reduce their impact as it won't be possible to exploit the XSS<br>vulnerability to steal session-cookies.

## Ask Yourself Whether

- the cookie is sensitive, used to authenticate the user, for instance a *session-cookie*
- the `HttpOnly` attribute offer an additional protection (not the case for an *XSRF-TOKEN cookie* / CSRF token for example)<br>


You are at risk if you answered yes to any of those questions.

## Recommended Secure Coding Practices

- By default the `HttpOnly` flag should be set to *true* for most of the cookies and it's mandatory for session /<br>  sensitive-security cookies.


## Sensitive Code Examples

For example In C# you can specify the HttpOnly flag for [HttpCookie](https://docs.microsoft.com/en-us/dotnet/api/system.web.httpcookie?view=netframework-4.8) object.


    HttpCookie myCookie = new HttpCookie("Sensitive cookie");
    myCookie.HttpOnly = false;  // Sensitive:  this sensitive cookie is created with the httponly flag set to false and so it can be stolen easily in case of XSS vulnerability


The [default value](https://docs.microsoft.com/en-us/dotnet/api/system.web.httpcookie.httponly?view=netframework-4.8) of<br>`secure` flag is false:


    HttpCookie myCookie = new HttpCookie("Sensitive cookie");
    // Sensitive: this sensitive cookie is created with the httponly flag not defined (by default set to false)  and so it can be stolen easily in case of XSS vulnerability


## Compliant Solution


    HttpCookie myCookie = new HttpCookie("Sensitive cookie");
    myCookie.HttpOnly = true; // Compliant: the sensitive cookie is protected against theft thanks to the HttpOnly property set to true (HttpOnly = true)


## See

- [OWASP HttpOnly](https://www.owasp.org/index.php/HttpOnly)
- [OWASP Top 10 2017 Category A7](https://www.owasp.org/index.php/Top_10-2017_A7-Cross-Site_Scripting_%28XSS%29) - Cross-Site Scripting<br>  (XSS)
- [CWE-79](http://cwe.mitre.org/data/definitions/79.html) - Improper Neutralization of Input During Web Page Generation ('Cross-site<br>  Scripting')
- [CWE-1004](https://cwe.mitre.org/data/definitions/1004.html) - Sensitive Cookie Without 'HttpOnly' Flag
- [SANS Top 25](https://www.sans.org/top25-software-errors/#cat1) - Insecure Interaction Between Components
- Derived from FindSecBugs rule [HTTPONLY\_COOKIE](https://find-sec-bugs.github.io/bugs.htm#HTTPONLY_COOKIE)

