
The `ServiceContract` attribute specifies that a class or interface defines the communication contract of a Windows Communication<br>Foundation (WCF) service. The service operations of this class or interface are defined by `OperationContract` attributes added to methods.<br>It doesn't make sense to define a contract without any service operations; thus, in a `ServiceContract` class or interface at least one<br>method should be annotated with `OperationContract`. Similarly, WCF only serves `OperationContract` methods that are defined<br>inside `ServiceContract` classes or interfaces; thus, this rule also checks that `ServiceContract` is added to the containing<br>type of `OperationContract` methods.

## Noncompliant Code Example


    [ServiceContract]
    interface IMyService // Noncompliant
    {
      int MyServiceMethod();
    }


## Compliant Solution


    [ServiceContract]
    interface IMyService
    {
      [OperationContract]
      int MyServiceMethod();
    }

