
`Thread.Suspend` and `Thread.Resume` can give unpredictable results, and both methods have been deprecated. Indeed, if<br>`Thread.Suspend` is not used very carefully, a thread can be suspended while holding a lock, thus leading to a deadlock. Other safer<br>synchronization mechanisms should be used, such as `Monitor`, `Mutex`, and `Semaphore`.

## Noncompliant Code Example


    static void Main(string[] args)
    {
      // ...
      Thread.CurrentThread.Suspend(); // Noncompliant
      Thread.CurrentThread.Resume(); // Noncompliant
    }


## See

- [Thread.Resume Method ()](https://msdn.microsoft.com/en-us/library/system.threading.thread.resume.aspx)
- [Thread.Suspend Method ()](https://msdn.microsoft.com/en-us/library/system.threading.thread.suspend%28v=vs.110%29.aspx)

