
The NET Framework 2.0 introduced the generic interface `System.Collections.Generic.IEnumerable<T>` and it should be preferred over<br>the older, non generic, interfaces.

This rule raises an issue when a public type implements `System.Collections.IEnumerable`.

## Noncompliant Code Example


    using System;
    using System.Collections;
    
    public class MyData
    {
      public MyData()
      {
      }
    }
    
    public class MyList : CollectionBase // Noncompliant
    {
      public void Add(MyData data)
      {
        InnerList.Add(data);
      }
    
      // ...
    }


## Compliant Solution


    using System;
    using System.Collections.ObjectModel;
    
    public class MyData
    {
      public MyData()
      {
      }
    }
    
    public class MyList : Collection&lt;MyData&gt;
    {
      // Implementation...
    }

