
A proper implementation of `IDisposable.Dispose` should allow for it to be called multiple times on the same object, however this is not<br>guaranteed and could result in an exception being thrown.

It is best not to rely on this behaviour and therefore make sure an object is disposed only once on all execution paths. This is particularly true<br>when dealing with nested `using` statements.

## Noncompliant Code Example


    using (Stream stream = new FileStream("file.txt", FileMode.OpenOrCreate))
    {
        using (StreamWriter writer = new StreamWriter(stream))  // Noncompliant: 'stream' will be disposed twice
        {
            // Use the writer object...
        }
    }


## Compliant Solution


    Stream stream = null;
    try
    {
        stream = new FileStream("file.txt", FileMode.OpenOrCreate);
        using (StreamWriter writer = new StreamWriter(stream))
        {
            stream = null;
            // Use the writer object...
        }
    }
    finally
    {
        if(stream != null)
            stream.Dispose();
    }

